--[[
	Bongos Minimap
		button dragging and hidding functions
--]]


BongosMinimap.Shapes = {
	["ROUND"] 					= {true, true, true, true},
	["SQUARE"] 					= {false, false, false, false},
	["CORNER-TOPLEFT"] 			= {false, true, false, false},
	["CORNER-TOPRIGHT"] 		= {true, false, false, false},
	["CORNER-BOTTOMLEFT"] 		= {false, false, true, false},
	["CORNER-BOTTOMRIGHT"]	 	= {false, false, false, true},
	["SIDE-LEFT"] 				= {false, true, true, false},
	["SIDE-RIGHT"] 				= {true, false, false, true},
	["SIDE-TOP"] 				= {true, true, false, false},
	["SIDE-BOTTOM"] 			= {false, false, true, true},
	["TRICORNER-TOPLEFT"] 		= {true, true, true, false},
	["TRICORNER-TOPRIGHT"] 		= {true, true, false, true},
	["TRICORNER-BOTTOMLEFT"] 	= {false, true, true, true},
	["TRICORNER-BOTTOMRIGHT"] 	= {true, false, true, true},
}

function BongosMinimap:GetButtonPosition(button)
	local cx, cy = GetCursorPosition(UIParent)
	local mx, my = Minimap:GetLeft(), Minimap:GetBottom()
	local z = Minimap:GetEffectiveScale()
	local w = button:GetWidth()
	
	local vector = 180 - deg(math.atan2(cy / z - my - 70, mx - cx / z + 70))
	local radius = ( Minimap:GetWidth() + w ) / 2 - w * w * 0.006
	
	local x, y
	if self.Shapes[GetMinimapShape() or "ROUND"][ceil(vector / 90)] then
		x = (radius) * cos(vector) - 1
		y = (radius) * sin(vector) - 1
	else
		x = max(-radius, min(110 * cos(vector) - 1, radius))
		y = max(-radius, min(110 * sin(vector) - 1, radius))
	end
	 
	return x, y
end


--[[ Register Buttons ]]--

function BongosMinimap:RegisterButtons(...)
	for i = 1, select('#', ...) do
	
		local button = select(i, ...)
		button:RegisterForDrag("LeftButton")
		button:SetClampedToScreen(true)
		button:SetMovable(true)
		
		local name = button:GetName()
		if not name then
			error(format("BongosMinimap:RegisterButtons(frame1, frame2,...) : frame #%s must have a name", i), 2)
		end
		
		local saved = self.sets[name]
		if saved then
			button:ClearAllPoints()
			button:SetPoint("TOP", "Minimap", "TOP", 0, saved.x)
			button:SetPoint("RIGHT", "Minimap", "RIGHT", saved.y, 0)
		end
	
		button:SetScript("OnDragStart", function()
			if(not self.sets.lockButtons) then
				button:StartMoving()
				self:SetScript("OnUpdate", function()
					if(self.sets.stickyButtons) then
					 	local x, y = self:GetButtonPosition(button)
					 	button:ClearAllPoints()
					 	button:SetPoint("CENTER", Minimap, "CENTER", x, y)
					end
				end)
			end
		end)
		
		button:SetScript("OnDragStop", function()
			if(not self.sets.lockButtons) then
				button:StopMovingOrSizing()
				self:SetScript("OnUpdate", nil)
				
				local x = button:GetTop() - Minimap:GetTop()
				local y = button:GetRight() - Minimap:GetRight()
				
				button:ClearAllPoints()
				button:SetPoint("TOP", "Minimap", "TOP", 0, x)
				button:SetPoint("RIGHT", "Minimap", "RIGHT", y, 0)	
				self.sets[name] = {x = x, y = y}
			end
		end)
	end
end


--[[ Show/Hide Buttons ]]--

function BongosMinimap:ToggleButtons()
	self:ToggleButton(MiniMapWorldMapButton, "showMap")
	self:ToggleButton(MiniMapTracking, "showTracker")
	self:ToggleButton(GameTimeFrame, "showDay")
	self:ToggleButton(MinimapZoomIn, "showZoom")
	self:ToggleButton(MinimapZoomOut, "showZoom")
	
	self:ToggleDinamicButton(MiniMapMailFrame, "showMail", HasNewMail)
	
	self:ToggleDinamicButton(MiniMapBattlefieldFrame, "showBattle", function()
		return BattlefieldFrame.numQueues
	end)
	
	self:ToggleDinamicButton(MiniMapVoiceChatFrame, "showVoice", function()
		return IsVoiceChatEnabled() and GetNumVoiceSessions()
	end)
	
end

function BongosMinimap:ToggleButton(button, arg)
	if self.sets[arg] then
		button:Show()
	else
		button:Hide()
	end
end

function BongosMinimap:ToggleDinamicButton(button, arg, IsEnabled)
	if self.sets[arg] then
		button:SetScript('OnShow', nil)
		if IsEnabled() then
			button:Show()
		end
	else
		button:SetScript('OnShow', function() this:Hide() end)
		button:Hide()
	end
end